/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.zend.communication;

import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.net.Socket;
import org.eclipse.core.runtime.Preferences;
import org2.eclipse.php.internal.debug.core.daemon.AbstractDebuggerCommunicationDaemon;
import org2.eclipse.php.internal.debug.core.daemon.ICommunicationDaemon;
import org2.eclipse.php.internal.debug.core.zend.communication.DebugConnectionThread;

public class DebuggerCommunicationDaemon
extends AbstractDebuggerCommunicationDaemon
implements ICommunicationDaemon {
    public static final String ZEND_DEBUGGER_ID = "org2.eclipse.php.debug.core.zendDebugger";
    public static final int[] DEBUGGER_DEFAULT_PORTS = new int[]{10000, 10137};
    private Preferences.IPropertyChangeListener portChangeListener;

    @Override
    public void init() {
        this.initDeamonChangeListener();
        super.init();
    }

    protected void initDeamonChangeListener() {
        if (this.portChangeListener == null) {
            Preferences preferences = PHPDebugEPLPlugin.getDefault().getPluginPreferences();
            this.portChangeListener = new PortChangeListener();
            preferences.addPropertyChangeListener(this.portChangeListener);
        }
    }

    @Override
    public int getReceiverPort() {
        return PHPDebugEPLPlugin.getDebugPort(ZEND_DEBUGGER_ID);
    }

    @Override
    protected void startConnectionThread(Socket socket) {
        new DebugConnectionThread(socket);
    }

    @Override
    public String getDebuggerID() {
        return ZEND_DEBUGGER_ID;
    }

    @Override
    public boolean isDebuggerDaemon() {
        return true;
    }

    public static boolean isDefaultDebugPort(int port) {
        int[] nArray = DEBUGGER_DEFAULT_PORTS;
        int n = DEBUGGER_DEFAULT_PORTS.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == port) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private class PortChangeListener
    implements Preferences.IPropertyChangeListener {
        private PortChangeListener() {
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (event.getProperty().equals("com.aptana.php.debug.eplzend_debug_port")) {
                DebuggerCommunicationDaemon.this.resetSocket();
            }
        }
    }
}

